@extends('layouts.app')
@section('title', 'SRI BALAJI SUPERMARKET - DAILY SETTELEMT REPORT')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1>SRI BALAJI SUPERMARKET - DAILY SETTELEMT REPORT</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row no-print">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action('ReportController@getStockReport'), 'method' => 'get', 'id' => 'register_report_filter_form' ]) !!}
                <div class="col-md-4">
                    <div class="form-group">
                        {!! Form::label('register_user_id',  __('report.user') . ':') !!}
                        {!! Form::select('register_user_id', $users, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('report.all_users')]); !!}
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        {!! Form::label('register_status',  __('sale.status') . ':') !!}
                        {!! Form::select('register_status', ['open' => __('cash_register.open'), 'close' => __('cash_register.close')], null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('report.all')]); !!}
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        {!! Form::label('register_report_date_range', __('report.date_range') . ':') !!}
                        {!! Form::text('register_report_date_range', null , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'register_report_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group" style="margin-top: 25px;">
                        <button type="button" class="btn btn-danger" id="close_all_registers_btn">
                            @lang('cash_register.close') @lang('report.all') (@lang('report.date_range'))
                        </button>
                        <button type="button" class="btn btn-primary" id="print_register_report_btn"
                            data-print-url="{{ action('ReportController@printRegisterReport') }}"
                            aria-label="Print" style="margin-left: 8px;">
                            <i class="fa fa-print"></i> @lang('messages.print')
                        </button>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <table class="table table-bordered table-striped" id="register_report_table">
                    <thead>
                        <tr>
                            <th>@lang('report.user')</th>
                            <th>Cash sales</th>
                            <th>Card sales (and card)</th>
                            <th>GPay sales</th>
                            <th>Paytm sales</th>
                            <th>Sodexo Pluxee sales</th>
                            <th>Credit sales</th>
                            <th>Sales return</th>
                            <th>Total sales</th>
                            <th>@lang('messages.action')</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr class="bg-gray font-17 text-center footer-total">
                            <td><strong>@lang('sale.total'):</strong></td>
                            <td class="footer_total_cash_payment"></td>
                            <td class="footer_total_card_payment"></td>
                            <td class="footer_total_custom_pay_1"></td>
                            <td class="footer_total_custom_pay_3"></td>
                            <td class="footer_total_custom_pay_2"></td>
                            <td class="footer_total_credit_sale"></td>
                            <td class="footer_total_sales_return"></td>
                            <td class="footer_total"></td>
                            <td></td>
                        </tr>
                    </tfoot>
                </table>
            @endcomponent
        </div>
    </div>
</section>
<!-- /.content -->
<div class="modal fade view_register" tabindex="-1" role="dialog" 
    aria-labelledby="gridSystemModalLabel">
</div>

@endsection

@section('javascript')
    <script src="{{ asset('js/report.js?v=' . $asset_v) }}"></script>
@endsection