<style>
    @page  {
  size: auto; 
  margin: 0mm 1mm 0mm 0mm;  
}
</style>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="X-UA-Compatible" content="ie=edge">
        <!-- <link rel="stylesheet" href="style.css"> -->
        <title>Receipt-<?php echo e($receipt_details->invoice_no, false); ?></title>
    </head>
    <body>
        
        <?php //print_r($receipt_details); ?>
        <div class="ticket">
        	<?php if(!empty($receipt_details->logo)): ?>
        		<div class="text-box centered">
        			<img style="max-height: 100px; width: auto;" src="<?php echo e($receipt_details->logo, false); ?>" alt="Logo">
        		</div>
        	<?php endif; ?>
        	<div class="text-box">
        	<!-- Logo -->
            <p class="centered" style="font-size:12px;">
            	<!-- Header text -->
            	<?php if(!empty($receipt_details->header_text)): ?>
            		<span class="headings"><?php echo $receipt_details->header_text; ?></span>
					<br/>
				<?php endif; ?>
				<!-- business information here -->
				<?php if(!empty($receipt_details->display_name)): ?>
					<span class="headings" style="font-size:14px;">
						<?php echo e($receipt_details->display_name, false); ?>

					</span>
					<br/>
				<?php endif; ?>
				<?php if(!empty($receipt_details->sub_heading_line1)): ?>
					<span style="font-size:12px;">(<?php echo e($receipt_details->sub_heading_line1, false); ?>)<br/></span>
				<?php endif; ?>
				
				<?php if(!empty($receipt_details->address)): ?>
					<span ><?php echo $receipt_details->address; ?>

					
					
					</span>
					<br/>
				<?php endif; ?>

				<?php if(!empty($receipt_details->contact)): ?>
					<?php echo $receipt_details->contact; ?>

				<?php endif; ?>
				<?php if(!empty($receipt_details->contact) && !empty($receipt_details->website)): ?>
					, 
				<?php endif; ?>
				<?php if(!empty($receipt_details->website)): ?>
					<?php echo e($receipt_details->website, false); ?>

				<?php endif; ?>
				<?php if(!empty($receipt_details->location_custom_fields)): ?>
					<br><?php echo e($receipt_details->location_custom_fields, false); ?>

				<?php endif; ?>

				
				<?php if(!empty($receipt_details->sub_heading_line2)): ?>
					<?php echo e($receipt_details->sub_heading_line2, false); ?><br/>
				<?php endif; ?>
				<?php if(!empty($receipt_details->sub_heading_line3)): ?>
					<?php echo e($receipt_details->sub_heading_line3, false); ?><br/>
				<?php endif; ?>
				<?php if(!empty($receipt_details->sub_heading_line4)): ?>
					<?php echo e($receipt_details->sub_heading_line4, false); ?><br/>
				<?php endif; ?>		
				<?php if(!empty($receipt_details->sub_heading_line5)): ?>
					<?php echo e($receipt_details->sub_heading_line5, false); ?><br/>
				<?php endif; ?>

				<?php if(!empty($receipt_details->tax_info1)): ?>
					<br><b><?php echo e($receipt_details->tax_label1, false); ?> <?php echo e($receipt_details->tax_info1, false); ?></b> 
				<?php endif; ?>

				<?php if(!empty($receipt_details->tax_info2)): ?>
					<b><?php echo e($receipt_details->tax_label2, false); ?></b> <?php echo e($receipt_details->tax_info2, false); ?>

				<?php endif; ?>

				<!-- Title of receipt -->
				<?php if(!empty($receipt_details->invoice_heading)): ?>
					<br><span class="sub-headings"><?php echo $receipt_details->invoice_heading; ?></span>
				<?php endif; ?>
			</p>
			</div>
			
			
	<div class="textbox-info border-top">
				<p class="f-left"><strong>Name</strong> :<?php echo e($receipt_details->customer_name, false); ?></p>
				<p class="f-right">
					<strong><?php echo $receipt_details->invoice_no_prefix; ?></strong> :<?php echo e($receipt_details->invoice_no, false); ?>

				</p>
			</div>
			
			<?php $old_date_timestamp = strtotime($receipt_details->invoice_date); ?>
			<div class="textbox-info">
				<p class="f-left"><strong>Mobile</strong> :<?php echo e($receipt_details->customer_mobile, false); ?></p>
				<p class="f-right">
					<strong><?php echo $receipt_details->date_label; ?></strong> :<?php echo e(date('d-m-Y', $old_date_timestamp), false); ?>

				</p>
			</div>
			<div class="textbox-info">
				<p class="f-left"><strong><?php echo e($receipt_details->sales_person_label, false); ?></strong> :<?php echo e($receipt_details->sales_person, false); ?></p>
				<p class="f-right">
					<strong>Time</strong> :<?php echo e(date('h-i A', $old_date_timestamp), false); ?>

				</p>
			</div>
			
			
			<?php $dis=0; ?>
                <?php $__currentLoopData = $receipt_details->lines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $line): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($line['total_line_discount']!='0.00') $dis=1;  ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <table style="margin-top: 5px !important" style="font-size:10px;" class="width-100 table-f-7">
                <thead class=" border-top-dotted">
                    <tr>
                       <!-- <th class="serial_number">#</th>-->
                        <th >
                        	<?php echo e($receipt_details->table_product_label, false); ?>

                        </th>

                        <!--<th class="quantity text-center" width="10%">
                        	MRP
                        </th>-->
                        <?php if(empty($receipt_details->hide_price)): ?>
                        <th class="unit_price text-center" width="15%">
                        	<?php echo e($receipt_details->table_unit_price_label, false); ?>

                        </th>
                        <?php if(!empty($receipt_details->item_discount_label) && $dis==1): ?>
							<th class="text-center" ><?php echo e($receipt_details->item_discount_label, false); ?></th>
						<?php endif; ?>
						<th class="text-center" >Net Rate</th>
						<th class="quantity text-center" width="10%">
                        	<?php echo e($receipt_details->table_qty_label, false); ?>

                        </th>
                        <th class="price " ><?php echo e($receipt_details->table_subtotal_label, false); ?></th>
                        <?php endif; ?>
                    </tr>
                </thead>
                <?php $line_subtotal=0;$pro_qty=0; $tax_saving=0; ?>
                <tbody class="border-top-dotted">
                	<?php $__empty_1 = true; $__currentLoopData = $receipt_details->lines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $line): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
	                    <tr >
	                       <!-- <td class="serial_number" style="vertical-align: top;">
	                        	<?php echo e($loop->iteration, false); ?>

	                        </td>-->
	                        <td colspan="5" class="description">
	                        	<?php echo e($line['name'], false); ?> <?php echo e($line['product_variation'], false); ?> <?php echo e($line['variation'], false); ?> 
	                        	<?php if(!empty($line['sub_sku'])): ?>, <?php echo e($line['sub_sku'], false); ?> <?php endif; ?> <?php if(!empty($line['brand'])): ?>, <?php echo e($line['brand'], false); ?> <?php endif; ?> <?php if(!empty($line['cat_code'])): ?>, <?php echo e($line['cat_code'], false); ?><?php endif; ?>
	                        	<?php if(!empty($line['product_custom_fields'])): ?>, <?php echo e($line['product_custom_fields'], false); ?> <?php endif; ?>
	                        	<?php if(!empty($line['sell_line_note'])): ?>
	                        	<br>
	                        	<span class="f-8">
	                        	<?php echo e($line['sell_line_note'], false); ?>

	                        	</span>
	                        	<?php endif; ?> 
	                        	<?php if(!empty($line['lot_number'])): ?><br> <?php echo e($line['lot_number_label'], false); ?>:  <?php echo e($line['lot_number'], false); ?> <?php endif; ?> 
	                        	<?php if(!empty($line['product_expiry'])): ?>, <?php echo e($line['product_expiry_label'], false); ?>:  <?php echo e($line['product_expiry'], false); ?> <?php endif; ?>
	                        	<?php if(!empty($line['warranty_name'])): ?>
	                            	<br>
	                            	<small>
	                            		<?php echo e($line['warranty_name'], false); ?>

	                            	</small>
	                            <?php endif; ?>
	                            <?php if(!empty($line['warranty_exp_date'])): ?>
	                            	<small>
	                            		- <?php echo e(\Carbon::createFromTimestamp(strtotime($line['warranty_exp_date']))->format(session('business.date_format')), false); ?>

	                            </small>
	                            <?php endif; ?>
	                            <?php if(!empty($line['warranty_description'])): ?>
	                            	<small> <?php echo e($line['warranty_description'] ?? '', false); ?></small>
	                            <?php endif; ?>
	                        </td>
	                        
	                    </tr>
	                    <tr ><!--class="border-bottom-dotted"-->
	                        <td >&nbsp;</td>
	                        <?php $line['sell_price_inc_tax']=str_replace(",","",$line['sell_price_inc_tax']); // $tax_saving=$tax_saving+($line['quantity_uf']*$line['tax_unformatted']); ?>
	                       <!-- <td  class="quantity text-center"><?php if(!empty($line['product_mrp'])): ?> <?php echo e(number_format((float)$line['product_mrp'], 2, '.', ''), false); ?> <?php else: ?> - <?php endif; ?></td>-->
	                        <?php if(empty($receipt_details->hide_price)): ?>
	                        <td class="unit_price text-center"><!--<?php echo e(round($line['unit_price_before_discount']), false); ?>----><?php echo e(($line['sell_price_inc_tax_uf']), false); ?></td>
	                        <?php if(!empty($receipt_details->item_discount_label)): ?>
								<td class="text-center">
        						<!--	<?php echo e($line['total_line_discount'] ?? 0, false); ?>-->
        							<?php if(!empty($line['line_discount_percent'])): ?>
        							 	<?php echo e(round($line['line_discount_percent']), false); ?>%
        							 <?php else: ?>
        							 	<?php echo e($line['total_line_discount'] ?? 0, false); ?>

        							<?php endif; ?>
								
								</td>
							<?php endif; ?>
							<td class="price text-center" ><?php echo e(($line['unit_price_inc_tax']), false); ?></td>
							<td  class="quantity text-center"><?php echo e(round($line['quantity']), false); ?> </td> <!--(<?php echo e($line['units'], false); ?>)-->
	                        <td class="price text-center" ><?php  
	                        
	                        
	                        
	                        $line_subtotal=$line_subtotal+$line['quantity_uf']*$line['sell_price_inc_tax']; ?>₹ <?php echo e($line['quantity_uf']*$line['sell_price_inc_tax'], false); ?></td>
	                        <?php endif; ?>
	                    </tr>
	                    <?php if(!empty($line['modifiers'])): ?>
							<?php $__currentLoopData = $line['modifiers']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $modifier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<tr>
									<td>
										&nbsp;
									</td>
									<td>
			                            <?php echo e($modifier['name'], false); ?> <?php echo e($modifier['variation'], false); ?> 
			                            <?php if(!empty($modifier['sub_sku'])): ?>, <?php echo e($modifier['sub_sku'], false); ?> <?php endif; ?> <?php if(!empty($modifier['cat_code'])): ?>, <?php echo e($modifier['cat_code'], false); ?><?php endif; ?>
			                            <?php if(!empty($modifier['sell_line_note'])): ?>(<?php echo e($modifier['sell_line_note'], false); ?>) <?php endif; ?> 
			                        </td>
									<td class="text-right"><?php echo e($modifier['quantity'], false); ?> <?php echo e($modifier['units'], false); ?> </td>
									<?php if(empty($receipt_details->hide_price)): ?>
									<td class="text-right"><?php echo e($modifier['unit_price_inc_tax'], false); ?></td>
									<?php if(!empty($receipt_details->item_discount_label)): ?>
										<td class="text-right">0.00</td>
									<?php endif; ?>
									<td class="text-right"><?php echo e($modifier['line_total'], false); ?></td>
									<?php endif; ?>
								</tr>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						<?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <!--<tr>
                    	<td <?php if(!empty($receipt_details->item_discount_label)): ?> colspan="6" <?php else: ?> colspan="5" <?php endif; ?>>&nbsp;</td>
                    </tr>-->
                </tbody>
            </table>
			<?php if(!empty($receipt_details->total_quantity_label)): ?>
				<div class="flex-box">
					<p class="left text-right">
						<?php echo $receipt_details->total_quantity_label; ?>

					</p>
					<p class="width-50 text-right">
						(<?php echo e($receipt_details->total_quantity, false); ?>)
					</p>
				</div>
			<?php endif; ?>
			<?php if(empty($receipt_details->hide_price)): ?>
                <div class="flex-box border-top-dotted" >
                    <p class="left text-right sub-headings">
                    	<?php echo $receipt_details->subtotal_label; ?>

                    </p>
                    <p class="width-50 text-right sub-headings">
                    	<!--<?php echo e($receipt_details->subtotal, false); ?>-->₹ <?php echo e(number_format((float)$line_subtotal, 2, '.', ''), false); ?>

                    </p>
                </div>

                <!-- Shipping Charges -->
				<?php if(!empty($receipt_details->shipping_charges)): ?>
					<div class="flex-box">
						<p class="left text-right">
							<?php echo $receipt_details->shipping_charges_label; ?>

						</p>
						<p class="width-50 text-right">
							<?php echo e($receipt_details->shipping_charges, false); ?>

						</p>
					</div>
				<?php endif; ?>

				<?php if(!empty($receipt_details->packing_charge)): ?>
					<div class="flex-box">
						<p class="left text-right">
							<?php echo $receipt_details->packing_charge_label; ?>

						</p>
						<p class="width-50 text-right">
							<?php echo e($receipt_details->packing_charge, false); ?>

						</p>
					</div>
				<?php endif; ?>

				<!-- Discount -->
				<?php if( !empty($receipt_details->discount) ): ?>
					<div class="flex-box">
						<p class="width-50 text-right">
							<!--<?php echo $receipt_details->discount_label; ?>-->Round Off Amt
						</p>

						<p class="width-50 text-right">
							(-) <?php echo e($receipt_details->discount, false); ?>

						</p>
					</div>
				<?php endif; ?>

				<?php if( !empty($receipt_details->total_line_discount) ): ?>
					<div class="flex-box">
						<p class="width-50 text-right">
							<?php echo $receipt_details->line_discount_label; ?>

						</p>

						<p class="width-50 text-right">
							(-) <?php echo e(number_format($receipt_details->total_line_discount_unformat+$tax_saving,2), false); ?>

						</p>
					</div>
				<?php endif; ?>

				<?php if( !empty($receipt_details->additional_expenses) ): ?>
					<?php $__currentLoopData = $receipt_details->additional_expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<div class="flex-box">
							<p class="width-50 text-right">
								<?php echo e($key, false); ?>:
							</p>

							<p class="width-50 text-right">
								(+) <?php echo e($val, false); ?>

							</p>
						</div>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				<?php endif; ?>

				<?php if(!empty($receipt_details->reward_point_label) ): ?>
					<div class="flex-box">
						<p class="width-50 text-right">
							<?php echo $receipt_details->reward_point_label; ?>

						</p>

						<p class="width-50 text-right">
							(-) <?php echo e($receipt_details->reward_point_amount, false); ?>

						</p>
					</div>
				<?php endif; ?>

<?php if(!empty($receipt_details->group_tax_details)): ?>
					<?php $__currentLoopData = $receipt_details->group_tax_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<div class="flex-box">
							<p class="width-50 text-right">
								<?php echo $key; ?>

							</p>
						<p class="width-50 text-right">
								(+) <?php echo e($value, false); ?>

						</p>
					</div>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
				<?php if( !empty($receipt_details->tax) ): ?>
					<div class="flex-box">
						<p class="width-50 text-right">
							<?php echo $receipt_details->tax_label; ?>

						</p>
						<p class="width-50 text-right">
							(+) <?php echo e($receipt_details->tax, false); ?>

						</p>
					</div>
				<?php endif; ?>

				<?php if( $receipt_details->round_off_amount > 0): ?>
					<div class="flex-box">
						<p class="width-50 text-right">
							<?php echo $receipt_details->round_off_label; ?> 
						</p>
						<p class="width-50 text-right">
							<?php echo e($receipt_details->round_off, false); ?>

						</p>
					</div>
				<?php endif; ?>
	
				<div class="flex-box">
					<p class="width-50 text-right main-headings">
						<?php echo $receipt_details->total_label; ?>

					</p>
					<p class="width-50 text-right main-headings">
						<?php echo e($receipt_details->total, false); ?>

					</p>
				</div>
			
				<?php if(!empty($receipt_details->total_in_words)): ?>
				<p colspan="2" class="text-right mb-0">
					<small>
					(<?php echo e($receipt_details->total_in_words, false); ?>)
					</small>
				</p>
				<?php endif; ?>
				

				<!-- Total Paid-->
				<?php if(!empty($receipt_details->total_paid)): ?>
					<!--<div class="flex-box border-bottom-dotted">
						<p class="width-50 text-right">
							<?php echo $receipt_details->total_paid_label; ?>

						</p>
						<p class="width-50 text-right">
							<?php echo e($receipt_details->total_paid, false); ?>

						</p>
					</div>-->
				<?php endif; ?>

				<!-- Total Due-->
				<?php if(!empty($receipt_details->total_due) && !empty($receipt_details->total_due_label)): ?>
					<div class="flex-box">
						<p class="width-50 text-right">
							<?php echo $receipt_details->total_due_label; ?>

						</p>
						<p class="width-50 text-right">
							<?php echo e($receipt_details->total_due, false); ?>

						</p>
					</div>
				<?php endif; ?>

				<?php if(!empty($receipt_details->all_due)): ?>
					<div class="flex-box">
						<p class="width-50 text-right">
							<?php echo $receipt_details->all_bal_label; ?>

						</p>
						<p class="width-50 text-right">
							<?php echo e($receipt_details->all_due, false); ?>

						</p>
					</div>
				<?php endif; ?>
			<?php endif; ?>
           

            <?php if(!empty($receipt_details->additional_notes)): ?>
	            <p class="centered">
	                
	            	<?php echo nl2br($receipt_details->additional_notes); ?>

	            </p>
            <?php endif; ?>
                        <div class="flex-box border-top-dotted">
							<p class="width-50 text-left"><b><u style="text-decoration: underline dotted black;text-underline-offset: 4px;">Payment Details:</u></b><br>
							 <?php if(!empty($receipt_details->payments)): ?>
            					<?php $__currentLoopData = $receipt_details->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

            							<span class="width-50 text-left"><?php echo e($payment['method'], false); ?> : <?php echo e($payment['amount'], false); ?> </span>
            					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            				<?php endif; ?>
							
							</p>
							<p class="width-50 text-right"><b><u style="text-decoration: underline dotted black;text-underline-offset: 4px;">GST Details:</u></b><br>
                							<?php if(empty($receipt_details->hide_price) && !empty($receipt_details->tax_summary_label) ): ?>
                                	            <!-- tax -->
                                	            <?php $i=1; ?>
                                	            <?php if(!empty($receipt_details->taxes)): ?>
                                            	            <?php $__currentLoopData = $receipt_details->taxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            	            			<?php  if(count($receipt_details->taxes)==$i){ ?> <?php echo e($key, false); ?>:
                            	            				<?php echo e($val, false); ?> <?php } $i++;?>
                            	            			
                            	            		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            	            	 <?php endif; ?>
                            <?php endif; ?>
							</p>
						</div>
               

            <?php if(!empty($receipt_details->footer_text)): ?>
				<p class="centered">
					<?php echo $receipt_details->footer_text; ?>

				</p>
			<?php endif; ?>
           

			<?php if($receipt_details->show_qr_code && !empty($receipt_details->qr_code_text)): ?>
				<img class="center-block mt-5" src="data:image/png;base64,<?php echo e(DNS2D::getBarcodePNG($receipt_details->qr_code_text, 'QRCODE'), false); ?>">
			<?php endif; ?>
			
			
			 
			<?php if($receipt_details->show_barcode): ?>
				<img class="center-block" src="data:image/png;base64,<?php echo e(DNS1D::getBarcodePNG($receipt_details->invoice_no, 'C128', 2,30,array(39, 48, 54), true), false); ?>">
			<?php endif; ?>
			
			<div class="centered border-bottom-dotted">
			</div>
			
			
	
    </body>
</html>

<style type="text/css">
.f-8 {
	font-size: 8px !important;
}
body {
	color: #000000;
}
@media  print {
	* {
    	font-size: 14px;
    	font-weight:600;
    	font-family: 'Times New Roman';
	}
	.f-8 {
		font-size: 12px !important;
	}
	
.headings{
	font-size: 20px;
	font-weight: 700;
	text-transform: uppercase;
	white-space: nowrap;
}

.sub-headings{
	font-size: 20px !important;
	font-weight: 700 !important;
}
.main-headings{
	font-size: 22px !important;
	font-weight: 800 !important;
}


.border-top{
    border-top: 1px solid black;
}
.border-bottom{
	border-bottom: 1px solid black;
}

.border-bottom-dotted{
	border-bottom: 1px dotted black;
}
.border-top-dotted{
	border-top: 1px dotted black;
}

td.serial_number, th.serial_number{
	width: 5%;
    max-width: 5%;
}

td.description,
th.description {
    width: 35%;
    max-width: 35%;
}

td.quantity,
th.quantity {
    width: 15%;
    max-width: 15%;
    word-break: break-all;
}
td.unit_price, th.unit_price{
	width: 25%;
    max-width: 25%;
    word-break: break-all;
}

td.price,
th.price {
    width: 20%;
    max-width: 20%;
    word-break: break-all;
}

.centered {
    text-align: center;
    align-content: center;
}

.ticket {
    width: 100%;
    max-width: 100%;
}

img {
    max-width: inherit;
    width: auto;
}

    .hidden-print,
    .hidden-print * {
        display: none !important;
    }
}
.table-info {
	width: 100%;
}
.table-info tr:first-child td, .table-info tr:first-child th {
	padding-top: 8px;
}
.table-info th {
	text-align: left;
}
.table-info td {
	text-align: right;
}
.logo {
	float: left;
	width:35%;
	padding: 10px;
}

.text-with-image {
	float: left;
	width:65%;
}
.text-box {
	width: 100%;
	height: auto;
}

.textbox-info {
	clear: both;
}
.textbox-info p {
	margin-bottom: 0px
}
.flex-box {
	display: flex;
	width: 100%;
	padding-right:15px;
}
.flex-box p {
	width: 50%;
	margin-bottom: 0px;
	white-space: nowrap
	padding-right:15px;
}

.table-f-12 th, .table-f-12 td {
	font-size: 12px;
	word-break: break-word;
}

.bw {
	word-break: break-word;
}
</style> <?php /**PATH /home/fmsbilling/public_html/highlights.firstmatrix.cfd/resources/views/sale_pos/receipts/slim.blade.php ENDPATH**/ ?>